<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables;

use Erlage\Photogram\Reflection\TraitReflectionAbstractClassName;

abstract class AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | reflection helper
    |--------------------------------------------------------------------------
    */

    use TraitReflectionAbstractClassName;

    /*
    |--------------------------------------------------------------------------
    | each table must have these
    |--------------------------------------------------------------------------
    */

    abstract public static function getPrimaryAttribute(): string;

    abstract public static function getLastUpdateStampAttribute(): string;

    abstract public static function getRegistrationStampAttribute(): string;

    abstract public static function getOwnerAttribute(): string;

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    abstract public static function getTableName(): string;

    abstract public static function getModelClassName(): string;

    /*
    |--------------------------------------------------------------------------
    | data ingestion & retrieval modifiers
    | implementations are provided so tables can skip where needed
    |--------------------------------------------------------------------------
    */

    public static function validators(): array
    {
        return array();
    }

    public static function transformers(): array
    {
        return array();
    }

    public static function serializers(): array
    {
        return array();
    }

    public static function deSerializers(): array
    {
        return array();
    }

    /*
    |--------------------------------------------------------------------------
    | database column/properties details of a table
    |--------------------------------------------------------------------------
    */

    abstract public static function allAttributes(): array;

    /*
    |--------------------------------------------------------------------------
    | properties that requires extra attention, 
    | note! these properties must exists in all properties
    |--------------------------------------------------------------------------
    */

    /**
     * Private attributes are sent to client only if client is the owner of those values
     */
    public static function privateAttributes(): array
    {
        return array();
    }

    /**
     * Protected values are never sent to client and they're available only at server
     */
    public static function protectedAttributes(): array
    {
        return array();
    }
}
